<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:variable name="refno"></xsl:variable>
<xsl:variable name="pinno"></xsl:variable>
<xsl:variable name="blockno"></xsl:variable>
<xsl:variable name="mode"></xsl:variable>
<xsl:template match="/">
	<html>
		<head>
			<style>
				body {
					background-color: #FFFFFF;
					margin: 10px;
					font-family: Arial,Helvetica;
					font-size: 9pt;
				}
				table {
					font-family: Arial, Helvetica;
					font-size: 9pt;
				}
			</style>
		</head>
		<body>
			<xsl:if test="$pinno != ''">
				<xsl:apply-templates select="//ROW[@REFNO=$refno and @PINNO=$pinno and @BLOCKNO=$blockno]/VALUE[@LINK != '' and @MODE=$mode]"/>
			</xsl:if> 
			<xsl:if test="$pinno = ''">
				<xsl:apply-templates select="//ROW[@REFNO=$refno and @BLOCKNO=$blockno]/VALUE[@LINK != '']"/>
			</xsl:if> 
		</body>
	</html>
</xsl:template>

<xsl:template match="//VALUE">
	<xsl:if test="../VALUE[@LINK != '']">
		<table border="0" cellpadding="4" cellspacing="1" bgcolor="#999999" style="display:inline;">
			<tr align="center" valign="middle" bgcolor="#FFFFFF">
				<td>
					<xsl:if test="contains(@LINK,'.svgz')">
						<embed border="0" align="middle" width="164" height="124" vspace="2" hspace="2">
							<xsl:attribute name="src">../wf/<xsl:value-of select="@LINK"/></xsl:attribute>
						</embed>
					</xsl:if>
					<xsl:if test="contains(@LINK,'.png') or contains(@LINK,'.gif') or contains(@LINK,'.bmp')">
						<img border="0" align="middle" width="160" height="120" vspace="2" hspace="2">
							<xsl:attribute name="src">../wf/<xsl:value-of select="@LINK"/></xsl:attribute>
						</img>
					</xsl:if>
				</td>
			</tr>
			<tr align="center" valign="middle" bgcolor="#F7F3F7">
				<td nowrap="nowrap">
					<xsl:value-of select="../@BLOCKNO"/>:
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
					<xsl:value-of select="../@REFNO"/> - Pin
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
					<xsl:value-of select="../@PINNO"/>
					<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;lt;</xsl:text>
					<xsl:value-of select="@MODE"/>
					<xsl:text disable-output-escaping="yes">&amp;gt;</xsl:text>
				</td>
			</tr>
		</table>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
